% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{replaceOutliers}
\alias{replaceOutliers}
\alias{replaceOutliersWithTrimmedMean}
\title{Replace outliers with trimmed mean}
\usage{
replaceOutliers(object, trim = 0.2, cooksCutoff, minReplicates = 7,
  whichSamples)

replaceOutliersWithTrimmedMean(object, trim = 0.2, cooksCutoff,
  minReplicates = 7, whichSamples)
}
\arguments{
\item{object}{a DESeqDataSet object, which has already been processed by
either DESeq, nbinomWaldTest or nbinomLRT, and therefore contains a matrix
contained in \code{assays(dds)[["cooks"]]}. These are the Cook's distances which will
be used to define outlier counts.}

\item{trim}{the fraction (0 to 0.5) of observations to be trimmed from
each end of the normalized counts for a gene before the mean is computed}

\item{cooksCutoff}{the threshold for defining an outlier to be replaced.
Defaults to the .99 quantile of the F(p, m - p) distribution, where p is
the number of parameters and m is the number of samples.}

\item{minReplicates}{the minimum number of replicate samples necessary to consider
a sample eligible for replacement (including itself). Outlier counts will not be replaced
if the sample is in a cell which has less than minReplicates replicates.}

\item{whichSamples}{optional, a numeric or logical index to specify
which samples should have outliers replaced. if missing, this is determined using
minReplicates.}
}
\value{
a DESeqDataSet with replaced counts in the slot returned by
\code{\link{counts}} and the original counts preserved in
\code{assays(dds)[["originalCounts"]]}
}
\description{
Note that this function is called within \code{\link{DESeq}}, so is not
necessary to call on top of a \code{DESeq} call. See the \code{minReplicatesForReplace}
argument documented in \code{link{DESeq}}.
}
\details{
This function replaces outlier counts flagged by extreme Cook's distances,
as calculated by \code{\link{DESeq}}, \code{\link{nbinomWaldTest}}
or \code{\link{nbinomLRT}}, with values predicted by the trimmed mean
over all samples (and adjusted by size factor or normalization factor).
This function replaces the counts in the matrix returned by \code{counts(dds)}
and the Cook's distances in \code{assays(dds)[["cooks"]]}. Original counts are
preserved in \code{assays(dds)[["originalCounts"]]}.

The \code{\link{DESeq}} function calculates a diagnostic measure called
Cook's distance for every gene and every sample. The \code{\link{results}}
function then sets the p-values to \code{NA} for genes which contain
an outlying count as defined by a Cook's distance above a threshold.
With many degrees of freedom, i.e. many more samples than number of parameters to 
be estimated-- it might be undesirable to remove entire genes from the analysis
just because their data include a single count outlier.
An alternate strategy is to replace the outlier counts
with the trimmed mean over all samples, adjusted by the size factor or normalization
factor for that sample. The following simple function performs this replacement
for the user, for samples which have at least \code{minReplicates} number
of replicates (including that sample).
For more information on Cook's distance, please see the two
sections of the vignette: 'Dealing with count outliers' and 'Count outlier detection'.
}
\seealso{
\code{\link{DESeq}}
}
