#lang scribble/doc
@(require "common.rkt")

@definterface/title[readable-snip<%> ()]{

A @racket[readable-snip<%>] object is treated specially by the port
 generated by @racket[open-input-text-editor]: When a
 @racket[readable-snip<%>] object is encountered for the input stream,
 its @method[readable-snip<%> read-special] method is called to
 generate the read result for the snip, which is returned from the
 port as a ``special'' value in the sense of
 @racket[read-char-or-special].

Since @racket[read] and @racket[read-syntax] build on
 @racket[read-char-or-special], a snip can implement
 @racket[readable-snip<%>] so that it produces a whole S-expression or
 some other kind of value when @racket[read] is used on a stream
 containing the snip.

@defmethod[(read-special [source any/c]
                         [line (or/c exact-nonnegative-integer? #f)]
                         [column (or/c exact-nonnegative-integer? #f)]
                         [position (or/c exact-nonnegative-integer? #f)])
           any/c]{

The arguments are the same as the arguments to a procedure returned by
 a custom input port's @racket[_read-in]; see @secref[#:doc '(lib
 "scribblings/reference/reference.scrbl") "customport"] for
 details. The result is also the same as the result from a
 @racket[_read-in]-produced procedure.


}}

