/*
 * Decompiled with CFR 0.152.
 */
package MCview;

import MCview.Atom;
import MCview.Bond;
import MCview.Residue;
import jalview.analysis.AlignSeq;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueProperties;
import jalview.structure.StructureMapping;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class PDBChain {
    private static final String PDBFILEFEATURE = "PDBFile";
    private static final String IEASTATUS = "IEA:jalview";
    public String id;
    public Vector bonds = new Vector();
    public Vector atoms = new Vector();
    public Vector residues = new Vector();
    public int offset;
    public Sequence sequence;
    public boolean isVisible = true;
    public int pdbstart = 0;
    public int pdbend = 0;
    public int seqstart = 0;
    public int seqend = 0;
    public String pdbid = "";

    public PDBChain(String pdbid, String id) {
        this.pdbid = pdbid.toLowerCase();
        this.id = id;
    }

    public String print() {
        String tmp = "";
        for (int i = 0; i < this.bonds.size(); ++i) {
            tmp = tmp + ((Bond)this.bonds.elementAt((int)i)).at1.resName + " " + ((Bond)this.bonds.elementAt((int)i)).at1.resNumber + " " + this.offset + "\n";
        }
        return tmp;
    }

    public void makeExactMapping(AlignSeq as, SequenceI s1) {
        int pdbpos = as.getSeq2Start() - 2;
        int alignpos = s1.getStart() + as.getSeq1Start() - 3;
        for (int i = 0; i < as.astr1.length(); ++i) {
            if (as.astr1.charAt(i) != '-') {
                ++alignpos;
            }
            if (as.astr2.charAt(i) != '-') {
                ++pdbpos;
            }
            if (as.astr1.charAt(i) != as.astr2.charAt(i)) continue;
            Residue res = (Residue)this.residues.elementAt(pdbpos);
            Enumeration en = res.atoms.elements();
            while (en.hasMoreElements()) {
                Atom atom = (Atom)en.nextElement();
                atom.alignmentMapping = alignpos;
            }
        }
    }

    public SequenceFeature[] transferRESNUMFeatures(SequenceI seq, String status) {
        SequenceI sq = seq;
        while (sq != null && sq.getDatasetSequence() != null) {
            if ((sq = sq.getDatasetSequence()) != this.sequence) continue;
            return null;
        }
        if (status == null) {
            status = IEASTATUS;
        }
        SequenceFeature[] features = this.sequence.getSequenceFeatures();
        for (int i = 0; i < features.length; ++i) {
            if (!features[i].getFeatureGroup().equals(this.pdbid)) continue;
            SequenceFeature tx = new SequenceFeature(features[i]);
            tx.setBegin(1 + ((Atom)((Residue)this.residues.elementAt((int)(tx.getBegin() - this.offset))).atoms.elementAt((int)0)).alignmentMapping);
            tx.setEnd(1 + ((Atom)((Residue)this.residues.elementAt((int)(tx.getEnd() - this.offset))).atoms.elementAt((int)0)).alignmentMapping);
            tx.setStatus(status + (tx.getStatus() == null || tx.getStatus().length() == 0 ? "" : ":" + tx.getStatus()));
            if (tx.begin == 0 || tx.end == 0) continue;
            sq.addSequenceFeature(tx);
        }
        return features;
    }

    public void makeCaBondList() {
        for (int i = 0; i < this.residues.size() - 1; ++i) {
            Residue tmpres = (Residue)this.residues.elementAt(i);
            Residue tmpres2 = (Residue)this.residues.elementAt(i + 1);
            Atom at1 = tmpres.findAtom("CA");
            Atom at2 = tmpres2.findAtom("CA");
            if (at1 != null && at2 != null) {
                if (!at1.chain.equals(at2.chain)) continue;
                this.makeBond(at1, at2);
                continue;
            }
            System.out.println("not found " + i);
        }
    }

    public void makeBond(Atom at1, Atom at2) {
        float[] start = new float[3];
        float[] end = new float[3];
        start[0] = at1.x;
        start[1] = at1.y;
        start[2] = at1.z;
        end[0] = at2.x;
        end[1] = at2.y;
        end[2] = at2.z;
        this.bonds.addElement(new Bond(start, end, at1, at2));
    }

    public void makeResidueList() {
        int i;
        int count = 0;
        StringBuffer seq = new StringBuffer();
        Vector<SequenceFeature> resFeatures = new Vector<SequenceFeature>();
        Vector<Annotation> resAnnotation = new Vector<Annotation>();
        int iSize = this.atoms.size() - 1;
        int resNumber = -1;
        for (i = 0; i <= iSize; ++i) {
            Atom tmp = (Atom)this.atoms.elementAt(i);
            int res = resNumber = tmp.resNumber;
            if (i == 0) {
                this.offset = resNumber;
            }
            Vector<Atom> resAtoms = new Vector<Atom>();
            while (resNumber == res && i < this.atoms.size()) {
                resAtoms.addElement((Atom)this.atoms.elementAt(i));
                if (++i < this.atoms.size()) {
                    resNumber = ((Atom)this.atoms.elementAt((int)i)).resNumber;
                    continue;
                }
                ++resNumber;
            }
            --i;
            this.residues.addElement(new Residue(resAtoms, resNumber - 1, count));
            Residue tmpres = (Residue)this.residues.lastElement();
            Atom tmpat = (Atom)tmpres.atoms.elementAt(0);
            SequenceFeature sf = new SequenceFeature("RESNUM", tmpat.resName + ":" + tmpat.resNumIns + " " + this.pdbid + this.id, "", this.offset + count, this.offset + count, this.pdbid);
            resFeatures.addElement(sf);
            resAnnotation.addElement(new Annotation(tmpat.tfactor));
            if (ResidueProperties.getAA3Hash().get(tmpat.resName) == null) {
                seq.append("X");
            } else {
                seq.append(ResidueProperties.aa[(Integer)ResidueProperties.getAA3Hash().get(tmpat.resName)]);
            }
            ++count;
        }
        if (this.id.length() < 1) {
            this.id = " ";
        }
        this.sequence = new Sequence(this.id, seq.toString(), this.offset, resNumber - 1);
        iSize = resFeatures.size();
        for (i = 0; i < iSize; ++i) {
            this.sequence.addSequenceFeature((SequenceFeature)resFeatures.elementAt(i));
            resFeatures.setElementAt(null, i);
        }
        Annotation[] annots = new Annotation[resAnnotation.size()];
        float max = 0.0f;
        iSize = annots.length;
        for (i = 0; i < iSize; ++i) {
            annots[i] = (Annotation)resAnnotation.elementAt(i);
            if (annots[i].value > max) {
                max = annots[i].value;
            }
            resAnnotation.setElementAt(null, i);
        }
        AlignmentAnnotation tfactorann = new AlignmentAnnotation("PDB.CATempFactor", "CA Temperature Factor for " + this.sequence.getName(), annots, 0.0f, max, 2);
        tfactorann.setSequenceRef(this.sequence);
        this.sequence.addAlignmentAnnotation(tfactorann);
    }

    public void setChargeColours() {
        for (int i = 0; i < this.bonds.size(); ++i) {
            try {
                Bond b = (Bond)this.bonds.elementAt(i);
                b.startCol = b.at1.resName.equalsIgnoreCase("ASP") || b.at1.resName.equalsIgnoreCase("GLU") ? Color.red : (b.at1.resName.equalsIgnoreCase("LYS") || b.at1.resName.equalsIgnoreCase("ARG") ? Color.blue : (b.at1.resName.equalsIgnoreCase("CYS") ? Color.yellow : Color.lightGray));
                if (b.at2.resName.equalsIgnoreCase("ASP") || b.at2.resName.equalsIgnoreCase("GLU")) {
                    b.endCol = Color.red;
                    continue;
                }
                if (b.at2.resName.equalsIgnoreCase("LYS") || b.at2.resName.equalsIgnoreCase("ARG")) {
                    b.endCol = Color.blue;
                    continue;
                }
                if (b.at2.resName.equalsIgnoreCase("CYS")) {
                    b.endCol = Color.yellow;
                    continue;
                }
                b.endCol = Color.lightGray;
                continue;
            }
            catch (Exception e) {
                Bond b = (Bond)this.bonds.elementAt(i);
                b.startCol = Color.gray;
                b.endCol = Color.gray;
            }
        }
    }

    public void setChainColours(ColourSchemeI cs) {
        for (int i = 0; i < this.bonds.size(); ++i) {
            Bond b;
            try {
                b = (Bond)this.bonds.elementAt(i);
                int index = (Integer)ResidueProperties.aa3Hash.get(b.at1.resName);
                b.startCol = cs.findColour(ResidueProperties.aa[index].charAt(0));
                index = (Integer)ResidueProperties.aa3Hash.get(b.at2.resName);
                b.endCol = cs.findColour(ResidueProperties.aa[index].charAt(0));
                continue;
            }
            catch (Exception e) {
                b = (Bond)this.bonds.elementAt(i);
                b.startCol = Color.gray;
                b.endCol = Color.gray;
            }
        }
    }

    public void setChainColours(Color col) {
        for (int i = 0; i < this.bonds.size(); ++i) {
            Bond tmp = (Bond)this.bonds.elementAt(i);
            tmp.startCol = col;
            tmp.endCol = col;
        }
    }

    public AlignmentAnnotation[] transferResidueAnnotation(SequenceI seq, String status) {
        AlignmentAnnotation[] transferred = null;
        return transferred;
    }

    public void transferResidueAnnotation(StructureMapping mapping) {
        SequenceI sq = mapping.getSequence();
        if (sq != null) {
            if (this.sequence == null || this.sequence.getAnnotation() != null) {
                // empty if block
            }
            float min = -1.0f;
            float max = 0.0f;
            Annotation[] an = new Annotation[sq.getEnd() - sq.getStart() + 1];
            int i = sq.getStart();
            int j = sq.getEnd();
            int k = 0;
            while (i <= j) {
                int prn = mapping.getPDBResNum(k + 1);
                an[k] = new Annotation(prn);
                if (min == -1.0f) {
                    min = k;
                    max = k;
                } else if (min > (float)k) {
                    min = k;
                } else if (max < (float)k) {
                    max = k;
                }
                ++i;
                ++k;
            }
            sq.addAlignmentAnnotation(new AlignmentAnnotation("PDB.RESNUM", "PDB Residue Numbering for " + this.pdbid + ":" + this.id, an, min, max, 2));
        }
    }
}

