#!/bin/bash

# DOC: https://clang.llvm.org/extra/clang-tidy/

if [ ! -d "src" ]; then
	echo "Usage: ./tools/clang-tidy.sh"
	exit 1
fi

CHECKS="*"\
",-cppcoreguidelines-owning-memory,-cppcoreguidelines-pro-bounds-array-to-pointer-decay,-cppcoreguidelines-pro-type-static-cast-downcast,-cppcoreguidelines-pro-type-vararg"\
",-fuchsia-default-arguments-calls"\
",-google-readability-braces-around-statements,-google-readability-todo"\
",-hicpp-braces-around-statements,-hicpp-vararg,-hicpp-no-array-decay"\
",-modernize-use-trailing-return-type"\
",-readability-braces-around-statements"\

run-clang-tidy \
	-checks "$CHECKS" \
	-j2 \
	-p build.tmp
