/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBreakAfterAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBreakBeforeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleColumnWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRelColumnWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleUseOptimalColumnWidthAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;

/**
 * DOM implementation of OpenDocument element  {@odf.element style:table-column-properties}.
 *
 */
public class StyleTableColumnPropertiesElement extends OdfStylePropertiesBase {

	public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.STYLE, "table-column-properties");

	/**
	 * Create the instance of <code>StyleTableColumnPropertiesElement</code>
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public StyleTableColumnPropertiesElement(OdfFileDom ownerDoc) {
		super(ownerDoc, ELEMENT_NAME);
	}

	/**
	 * Get the element name
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element style:table-column-properties}.
	 */
	public OdfName getOdfName() {
		return ELEMENT_NAME;
	}

	public final static OdfStyleProperty BreakAfter =
		OdfStyleProperty.get(OdfStylePropertiesSet.TableColumnProperties, OdfName.newName(OdfDocumentNamespace.FO, "break-after"));

	public final static OdfStyleProperty BreakBefore =
		OdfStyleProperty.get(OdfStylePropertiesSet.TableColumnProperties, OdfName.newName(OdfDocumentNamespace.FO, "break-before"));

	public final static OdfStyleProperty ColumnWidth =
		OdfStyleProperty.get(OdfStylePropertiesSet.TableColumnProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "column-width"));

	public final static OdfStyleProperty RelColumnWidth =
		OdfStyleProperty.get(OdfStylePropertiesSet.TableColumnProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "rel-column-width"));

	public final static OdfStyleProperty UseOptimalColumnWidth =
		OdfStyleProperty.get(OdfStylePropertiesSet.TableColumnProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "use-optimal-column-width"));

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBreakAfterAttribute</code> , See {@odf.attribute fo:break-after}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBreakAfterAttribute() {
		FoBreakAfterAttribute attr = (FoBreakAfterAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "break-after");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBreakAfterAttribute</code> , See {@odf.attribute fo:break-after}
	 *
	 * @param foBreakAfterValue   The type is <code>String</code>
	 */
	public void setFoBreakAfterAttribute(String foBreakAfterValue) {
		FoBreakAfterAttribute attr = new FoBreakAfterAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foBreakAfterValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBreakBeforeAttribute</code> , See {@odf.attribute fo:break-before}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBreakBeforeAttribute() {
		FoBreakBeforeAttribute attr = (FoBreakBeforeAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "break-before");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBreakBeforeAttribute</code> , See {@odf.attribute fo:break-before}
	 *
	 * @param foBreakBeforeValue   The type is <code>String</code>
	 */
	public void setFoBreakBeforeAttribute(String foBreakBeforeValue) {
		FoBreakBeforeAttribute attr = new FoBreakBeforeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foBreakBeforeValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleColumnWidthAttribute</code> , See {@odf.attribute style:column-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleColumnWidthAttribute() {
		StyleColumnWidthAttribute attr = (StyleColumnWidthAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "column-width");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleColumnWidthAttribute</code> , See {@odf.attribute style:column-width}
	 *
	 * @param styleColumnWidthValue   The type is <code>String</code>
	 */
	public void setStyleColumnWidthAttribute(String styleColumnWidthValue) {
		StyleColumnWidthAttribute attr = new StyleColumnWidthAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleColumnWidthValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleRelColumnWidthAttribute</code> , See {@odf.attribute style:rel-column-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleRelColumnWidthAttribute() {
		StyleRelColumnWidthAttribute attr = (StyleRelColumnWidthAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "rel-column-width");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleRelColumnWidthAttribute</code> , See {@odf.attribute style:rel-column-width}
	 *
	 * @param styleRelColumnWidthValue   The type is <code>String</code>
	 */
	public void setStyleRelColumnWidthAttribute(String styleRelColumnWidthValue) {
		StyleRelColumnWidthAttribute attr = new StyleRelColumnWidthAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleRelColumnWidthValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleUseOptimalColumnWidthAttribute</code> , See {@odf.attribute style:use-optimal-column-width}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleUseOptimalColumnWidthAttribute() {
		StyleUseOptimalColumnWidthAttribute attr = (StyleUseOptimalColumnWidthAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "use-optimal-column-width");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleUseOptimalColumnWidthAttribute</code> , See {@odf.attribute style:use-optimal-column-width}
	 *
	 * @param styleUseOptimalColumnWidthValue   The type is <code>Boolean</code>
	 */
	public void setStyleUseOptimalColumnWidthAttribute(Boolean styleUseOptimalColumnWidthValue) {
		StyleUseOptimalColumnWidthAttribute attr = new StyleUseOptimalColumnWidthAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(styleUseOptimalColumnWidthValue.booleanValue());
	}

	@Override
	public void accept(ElementVisitor visitor) {
		if (visitor instanceof DefaultElementVisitor) {
			DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
			defaultVisitor.visit(this);
		} else {
			visitor.visit(this);
		}
	}
}
