# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TriggerCondition(Model):
    """The condition that results in the Log Search rule.

    All required parameters must be populated in order to send to Azure.

    :param threshold_operator: Required. Evaluation operation for rule -
     'GreaterThan' or 'LessThan. Possible values include: 'GreaterThan',
     'LessThan', 'Equal'
    :type threshold_operator: str or
     ~azure.mgmt.monitor.models.ConditionalOperator
    :param threshold: Required. Result or count threshold based on which rule
     should be triggered.
    :type threshold: float
    :param metric_trigger: Trigger condition for metric query rule
    :type metric_trigger: ~azure.mgmt.monitor.models.LogMetricTrigger
    """

    _validation = {
        'threshold_operator': {'required': True},
        'threshold': {'required': True},
    }

    _attribute_map = {
        'threshold_operator': {'key': 'thresholdOperator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'metric_trigger': {'key': 'metricTrigger', 'type': 'LogMetricTrigger'},
    }

    def __init__(self, *, threshold_operator, threshold: float, metric_trigger=None, **kwargs) -> None:
        super(TriggerCondition, self).__init__(**kwargs)
        self.threshold_operator = threshold_operator
        self.threshold = threshold
        self.metric_trigger = metric_trigger
